<?php

$maxImageSize = setting('_general.max_image_size');

return [
    'id'        => 'categories',
    'name'      => __('Categories'),
    'icon'      => '<i class="icon-clipboard"></i>',
    'tab'       => "Common",
    'fields'    => [
        [
            'id'            => 'section_title_variation',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Section title variation'),
            'options'       => [
                'am-section_title_one'      => __('Classic'),
                'am-section_title_two'      => __('Traditional'),
                'am-section_title_three'    => __('Modern'),
            ],
            'default'       => 'am-section_title_one',
        ],
          [
            'id'            => 'categories_verient',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Select categories verient'),
            'options'       => [
                'verient-one'           => 'Verient one',
                'verient-two'           => 'Verient two',
                'am-verient-three'      => 'Verient three',
            ],
            'default'       => 'non',  
            'placeholder'   => __('settings.select_from_list'),  
        ],
        [
            'id'            => 'select_title_verient',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Select title varient'),
            'options'       => [
                ''                            => 'Select title style',
                'am-title-varient-one'        => 'Title style v1',
            ],
            'default'       => '',  
            'placeholder'   => __('settings.select_from_list'),  
        ],
        [
            'id'            => 'pre_heading_text_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading text color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading_bg_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading bg color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading'),
            'placeholder'   => __('Enter pre heading'),
        ],
        [
            'id'            => 'heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Heading'),
            'placeholder'   => __('Enter heading'),
        ],
        [
            'id'            => 'paragraph',
            'type'          => 'editor',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Description'),
            'placeholder'   => __('Enter description'),
        ],
        [                                                          
            'id'                => 'categories_repeater',
            'type'              => 'repeater',
            'label_title'       => __('Categories'),
            'repeater_title'    => __('Add category'),
            'multi'             => true,
            'fields'       => [
                [
                    'id'            => 'category_image',
                    'type'          => 'file',
                    'class'         => '',
                    'label_title'   => __('Category image'),
                    'label_desc'    => __('Add image'),
                    'max_size'      => $maxImageSize ?? 5,                  
                    'ext'    => [
                        'jpg',
                        'png',
                        'svg',
                        'jpeg',
                        'webp',
                    ], 
                ],
                [
                    'id'            => 'category_heading',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('Category heading'),
                    'placeholder'   => __('Enter heading'),
                ],
                [
                    'id'            => 'category_paragraph',
                    'type'          => 'editor',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('Category description'),
                    'placeholder'   => __('Enter description'),
                ],
                [
                    'id'            => 'explore_more_btn_url',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('Category button URL'),
                    'placeholder'   => __('Enter url'),
                ],
                [
                    'id'            => 'explore_more_btn_txt',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('Category button text'),
                    'placeholder'   => __('Enter button text'),
                ],
            ]
        ],
        [
            'id'            => 'all_category_heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('All category heading'),
            'placeholder'   => __('Enter heading'),
        ],
        [
            'id'            => 'all_category_paragraph',
            'type'          => 'editor',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('All category Description'),
            'placeholder'   => __('Enter description'),
        ],
        [
            'id'            => 'view_category_btn_url',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Primary button URL'),
            'placeholder'   => __('Enter url'),
        ],
        [
            'id'            => 'view_category_btn_txt',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Primary button text'),
            'placeholder'   => __('Enter button text'),
        ],
    ]
];
